//***************************************************************************
#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>             /* ANSI C standard library routines */
#include <string.h>             /* ANSI standard string routines */
#include <limits.h>
#include <math.h>
#include <stdio.h>
#include "image.h"
//***************************************************************************
void GrayImage::addSaltandPepperNoise (double percent)
{
cout << "   Adding " << percent << "% salt and pepper noise to the image...";
srand(1);
int count = 0;

double pr = 1.0-percent/100.0;
for (int i = 0; i < width; ++i)
	for (int j = 0; j < height; ++j)
		{
		 // Generate random number between -1.0 and +1.0
		 double random = 2.0*(rand()-RAND_MAX/2.0)/RAND_MAX;
		 if (random > pr)
			{
			 p[i][j] = 255;	// Salt noise
			 ++count;
			}
		 else if (random < -pr)
			{
			 p[i][j] = 0;    // Pepper noise
			 ++count;
			}
		}
double actualpercent = 100.0*count/(width*height);

cout << "done! (" << actualpercent << "%)" << endl;
}
//***************************************************************************
void GrayImage::addGaussianNoise (double mean, double variance)
{
cout << "  Adding Gaussian noise with mean = " << mean << " and variance = "
	<< variance << " to the image...";
cout.flush();
srand(1);
#define unit_random() (1.0*rand()/RAND_MAX)
#define TWO_PI 6.28318530717958647688

double temp, u1, u2;
int ix, iy;
int num = width*height;
int tempint;

u1=0.0;
for(int i = 0; i < num/2; i++)
	{
	 while (u1 == 0.0) u1 = unit_random();
	 u2 = unit_random();
	 temp = sqrt(-2.0*variance*log(u1));
	 ix = 2*i/width;
	 iy = 2*i%width;
	 tempint = p[ix][iy] + (int) (temp * cos(TWO_PI*u2) + mean);
	 if (tempint > 255)
		p[ix][iy] = 255;
	 else if (tempint < 0)
		p[ix][iy] = 0;
	 else
		p[ix][iy] = (unsigned char) tempint;
	 ix = (2*i+1)/width;
	 iy = (2*i+1)%width;
	 tempint = p[ix][iy] + (int) (temp * sin(TWO_PI*u2) + mean);
	 if (tempint > 255)
		p[ix][iy] = 255;
	 else if (tempint < 0)
		p[ix][iy] = 0;
	 else
		p[ix][iy] = (unsigned char) tempint;
	 u1 = 0.0;
	}

u1=0.0;
if(num & 1) // If num is odd
	{
	 while (u1 == 0.0) u1 = unit_random();
	 u2 = unit_random();
	 temp = sqrt(-2.0*variance*log(u1));
	 ix = (num-1)/width;
	 iy = (num-1)%width;
	 tempint = p[ix][iy] + (int) (temp * cos(TWO_PI*u2) + mean);
	 if (tempint > 255)
		p[ix][iy] = 255;
	 else if (tempint < 0)
		p[ix][iy] = 0;
	 else
		p[ix][iy] = (unsigned char) tempint;
	 u1 = 0.0;
	}

cout << "done!" << endl;
}
//***************************************************************************
