//***************************************************************************
#ifndef MATRIX_H
#define MATRIX_H
//***************************************************************************
class Matrix
{
   private:
	int	nx;
	int	ny;
	int	allocateFlag;
	void allocateMem (int m, int n);
	void deAllocateMem( );

    public:
	double   **p;
	Matrix ( );		// Constructor
	Matrix (int m, int n);		// Constructor
	~Matrix ( );		// Destructor
	void Identity ();
	Matrix &Transpose ();
	Matrix &operator+ (Matrix &M1);
	Matrix &operator- (Matrix &M1);
	Matrix &operator* (Matrix &M1);
	Matrix &operator* (double k);
	Matrix &operator/ (double k);
	Matrix &operator= (const Matrix &M);
	double operator() (int i, int j);
	friend ostream &operator<< (ostream &Out, Matrix &M);

};
//***************************************************************************
#define DEG2RAD (0.01745329251994329576)
#define RAD2DEG (57.29577951308232087721)
Matrix &Transpose (Matrix &M);
Matrix &xRotate (double angle);
Matrix &yRotate (double angle);
Matrix &zRotate (double angle);
Matrix &Translate (double x, double y, double z);
Matrix &Scale (double x, double y, double z);
Matrix &Perspective (double lambda);
Matrix &Identity (int n);
Matrix &TransformToImagePlane (double x0, double y0, double z0, double xC,
	double yC, double zC, double r1, double r2, double r3, double lambda);
void PerspectiveTransform (Matrix T, double x, double y, double z,
		        double *xp, double *yp);
//***************************************************************************
#endif // MATRIX_H
//***************************************************************************
