//***************************************************************************
#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>             /* ANSI C standard library routines */
#include <string.h>             /* ANSI standard string routines */
#include <limits.h>
#include <math.h>
#include <stdio.h>
#include "image.h"
//***************************************************************************
double RMSerror(GrayImage *I1, GrayImage *I2)
{
double err = 0.0;

if ((I1->height != I2->height) || (I1->width != I2->width))
	{
	 cerr << "RMSerror: Both images are not of the same size!!" << endl;
	 exit(-1);
	}

for (int i = 0; i < I1->width; i++)
	for (int j = 0; j < I1->height; j++)
		err += pow(I1->p[i][j]-I2->p[i][j], 2.0);
		
err /= 1.0*I1->width*I1->height;

return 100.0*sqrt(err)/I1->numLevels;
}
//***************************************************************************
